//
//  notePad_alphaAppDelegate.m
//  notePad alpha
//
//  Created by Fumihiro Tezuka on 10/08/30.
//  Copyright 2010 viva Cocoa. All rights reserved.
//

#import "notePad_alphaAppDelegate.h"

@implementation notePad_alphaAppDelegate

@synthesize window, notes;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	/* 可変オブジェクト配列の作成 */
	notes = [[NSMutableArray alloc] init];
	/* ファイルパスの設定 */
	filePath = [[NSMutableString alloc] init];
	[filePath appendString:NSHomeDirectory()];
	[filePath appendString:@"/Library/Application Support/viva Cocoa"];
	[[NSFileManager defaultManager] createDirectoryAtPath:filePath withIntermediateDirectories:YES attributes:nil error:NULL];
	[filePath appendString:@"/notePadAlpha.data"];
	/* データの読み込み */
	[self read];
	/* ユーザーデフォルトの読み込み */
	[self readUserDefaults];
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	return YES;
}

- (void)applicationWillTerminate:(NSNotification *)notification
{
	[self save];
}

- (void)save
{
	[NSKeyedArchiver archiveRootObject:notes toFile:filePath];
}

- (void)read
{
	id file;
	if (file = [NSKeyedUnarchiver unarchiveObjectWithFile:filePath]) {
		[self setNotes:file];
	}
}

/* メモを削除するときのアラート・シート */
- (IBAction)alertOnDeleting:(id)sender
{
	NSInteger itemNum = [controller selectionIndex] + 1;
	
	NSAlert *alert = [NSAlert alertWithMessageText:NSLocalizedString(@"DeleteTitle", nil) defaultButton:NSLocalizedString(@"Delete", nil) alternateButton:NSLocalizedString(@"Cancel", nil) otherButton:nil informativeTextWithFormat:NSLocalizedString(@"DeleteMessage", nil), itemNum];
	
	[alert beginSheetModalForWindow:window modalDelegate:self didEndSelector:@selector(alertDidEnd: returnCode: contextInfo:) contextInfo:NULL];
}

- (void)alertDidEnd:(NSAlert *)alert returnCode:(NSInteger)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSAlertDefaultReturn) {
		[controller remove:self];
	}
}

- (void)readUserDefaults
{
	id position = [[userDefaults values] valueForKey:@"windowPosition"];
	if ([position integerValue]) {
		[window center];
	}
	[panel center];
}

@end
